using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmReagentInventory
	/// </summary>
	public class FrmReagentInventory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpExpirationDate;
		private System.Windows.Forms.CheckBox cbExpireAfter;
		private System.Windows.Forms.DateTimePicker dtpExpireBefore;
		private System.Windows.Forms.GroupBox grpReceivedDate;
		private System.Windows.Forms.DateTimePicker dtpReceivedBefore;
		private System.Windows.Forms.DateTimePicker dtpReceivedAfter;
		private System.Windows.Forms.CheckBox cbReceivedAfter;
		private System.Windows.Forms.CheckBox cbReceivedBefore;
		private System.Windows.Forms.GroupBox grpReagentType;
		private System.Windows.Forms.CheckedListBox lstReagentType;
		private System.Windows.Forms.Button btnSelectAllReagents;
		private System.Windows.Forms.Button btnDeselectAllReagents;
		private System.Windows.Forms.DateTimePicker dtpExpireAfter;
		private System.Windows.Forms.CheckBox cbExpireBefore;
		private System.Windows.Forms.RadioButton rdoInDate;
		private System.Windows.Forms.RadioButton rdoExpired;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.RadioButton rdoDateRange;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		#endregion

		#region Variables
		DataTable _dtReagentTypes;
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmReagentInventory()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
			LoadReagentTypes();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmReagentInventory));
			this.grpExpirationDate = new System.Windows.Forms.GroupBox();
			this.dtpExpireAfter = new System.Windows.Forms.DateTimePicker();
			this.dtpExpireBefore = new System.Windows.Forms.DateTimePicker();
			this.cbExpireAfter = new System.Windows.Forms.CheckBox();
			this.cbExpireBefore = new System.Windows.Forms.CheckBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpReceivedDate = new System.Windows.Forms.GroupBox();
			this.dtpReceivedAfter = new System.Windows.Forms.DateTimePicker();
			this.dtpReceivedBefore = new System.Windows.Forms.DateTimePicker();
			this.cbReceivedBefore = new System.Windows.Forms.CheckBox();
			this.cbReceivedAfter = new System.Windows.Forms.CheckBox();
			this.grpReagentType = new System.Windows.Forms.GroupBox();
			this.btnSelectAllReagents = new System.Windows.Forms.Button();
			this.btnDeselectAllReagents = new System.Windows.Forms.Button();
			this.lstReagentType = new System.Windows.Forms.CheckedListBox();
			this.rdoInDate = new System.Windows.Forms.RadioButton();
			this.rdoExpired = new System.Windows.Forms.RadioButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.rdoDateRange = new System.Windows.Forms.RadioButton();
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.grpExpirationDate.SuspendLayout();
			this.grpReceivedDate.SuspendLayout();
			this.grpReagentType.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(410, 30);
			this.vbecsLogo1.TabIndex = 9;
			this.vbecsLogo1.Title = "Reagent Search";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 257);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 11;
			// 
			// grpExpirationDate
			// 
			this.grpExpirationDate.AccessibleDescription = "Expired Reagent Date Range";
			this.grpExpirationDate.AccessibleName = "Expired Reagent Date Range";
			this.grpExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpExpirationDate.Controls.Add(this.dtpExpireAfter);
			this.grpExpirationDate.Controls.Add(this.dtpExpireBefore);
			this.grpExpirationDate.Controls.Add(this.cbExpireAfter);
			this.grpExpirationDate.Controls.Add(this.cbExpireBefore);
			this.grpExpirationDate.Enabled = false;
			this.grpExpirationDate.Location = new System.Drawing.Point(232, 100);
			this.grpExpirationDate.Name = "grpExpirationDate";
			this.grpExpirationDate.Size = new System.Drawing.Size(172, 72);
			this.grpExpirationDate.TabIndex = 5;
			this.grpExpirationDate.TabStop = false;
			// 
			// dtpExpireAfter
			// 
			this.dtpExpireAfter.AccessibleDescription = "Expires After Date";
			this.dtpExpireAfter.AccessibleName = "Expires After Date";
			this.dtpExpireAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpireAfter.CustomFormat = "";
			this.dtpExpireAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpireAfter.Location = new System.Drawing.Point(76, 44);
			this.dtpExpireAfter.Name = "dtpExpireAfter";
			this.dtpExpireAfter.Size = new System.Drawing.Size(88, 20);
			this.dtpExpireAfter.TabIndex = 3;
			// 
			// dtpExpireBefore
			// 
			this.dtpExpireBefore.AccessibleDescription = "Expires Before Date";
			this.dtpExpireBefore.AccessibleName = "Expires Before Date";
			this.dtpExpireBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpireBefore.CustomFormat = "";
			this.dtpExpireBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpireBefore.Location = new System.Drawing.Point(76, 20);
			this.dtpExpireBefore.Name = "dtpExpireBefore";
			this.dtpExpireBefore.Size = new System.Drawing.Size(88, 20);
			this.dtpExpireBefore.TabIndex = 1;
			// 
			// cbExpireAfter
			// 
			this.cbExpireAfter.AccessibleDescription = "Expires After";
			this.cbExpireAfter.AccessibleName = "Expires After";
			this.cbExpireAfter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbExpireAfter.Location = new System.Drawing.Point(24, 44);
			this.cbExpireAfter.Name = "cbExpireAfter";
			this.cbExpireAfter.Size = new System.Drawing.Size(60, 16);
			this.cbExpireAfter.TabIndex = 2;
			this.cbExpireAfter.Text = "&After";
			// 
			// cbExpireBefore
			// 
			this.cbExpireBefore.AccessibleDescription = "Expires Before";
			this.cbExpireBefore.AccessibleName = "Expires Before";
			this.cbExpireBefore.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbExpireBefore.Location = new System.Drawing.Point(24, 20);
			this.cbExpireBefore.Name = "cbExpireBefore";
			this.cbExpireBefore.Size = new System.Drawing.Size(60, 16);
			this.cbExpireBefore.TabIndex = 0;
			this.cbExpireBefore.Text = "&Before";
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(328, 246);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 8;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(248, 246);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 7;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpReceivedDate
			// 
			this.grpReceivedDate.AccessibleDescription = "Received Date";
			this.grpReceivedDate.AccessibleName = "Received Date";
			this.grpReceivedDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpReceivedDate.Controls.Add(this.dtpReceivedAfter);
			this.grpReceivedDate.Controls.Add(this.dtpReceivedBefore);
			this.grpReceivedDate.Controls.Add(this.cbReceivedBefore);
			this.grpReceivedDate.Controls.Add(this.cbReceivedAfter);
			this.grpReceivedDate.Location = new System.Drawing.Point(232, 172);
			this.grpReceivedDate.Name = "grpReceivedDate";
			this.grpReceivedDate.Size = new System.Drawing.Size(172, 68);
			this.grpReceivedDate.TabIndex = 6;
			this.grpReceivedDate.TabStop = false;
			this.grpReceivedDate.Text = "Received Date";
			// 
			// dtpReceivedAfter
			// 
			this.dtpReceivedAfter.AccessibleDescription = "Received After Date";
			this.dtpReceivedAfter.AccessibleName = "Received After Date";
			this.dtpReceivedAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReceivedAfter.CustomFormat = "";
			this.dtpReceivedAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedAfter.Location = new System.Drawing.Point(76, 40);
			this.dtpReceivedAfter.Name = "dtpReceivedAfter";
			this.dtpReceivedAfter.Size = new System.Drawing.Size(88, 20);
			this.dtpReceivedAfter.TabIndex = 3;
			// 
			// dtpReceivedBefore
			// 
			this.dtpReceivedBefore.AccessibleDescription = "Received Before Date";
			this.dtpReceivedBefore.AccessibleName = "Received Before Date";
			this.dtpReceivedBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpReceivedBefore.CustomFormat = "";
			this.dtpReceivedBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedBefore.Location = new System.Drawing.Point(76, 16);
			this.dtpReceivedBefore.Name = "dtpReceivedBefore";
			this.dtpReceivedBefore.Size = new System.Drawing.Size(88, 20);
			this.dtpReceivedBefore.TabIndex = 1;
			// 
			// cbReceivedBefore
			// 
			this.cbReceivedBefore.AccessibleDescription = "Received Before";
			this.cbReceivedBefore.AccessibleName = "Received Before";
			this.cbReceivedBefore.Location = new System.Drawing.Point(24, 16);
			this.cbReceivedBefore.Name = "cbReceivedBefore";
			this.cbReceivedBefore.Size = new System.Drawing.Size(60, 20);
			this.cbReceivedBefore.TabIndex = 0;
			this.cbReceivedBefore.Text = "B&efore";
			// 
			// cbReceivedAfter
			// 
			this.cbReceivedAfter.AccessibleDescription = "Received After";
			this.cbReceivedAfter.AccessibleName = "Received After";
			this.cbReceivedAfter.Location = new System.Drawing.Point(24, 40);
			this.cbReceivedAfter.Name = "cbReceivedAfter";
			this.cbReceivedAfter.Size = new System.Drawing.Size(60, 20);
			this.cbReceivedAfter.TabIndex = 2;
			this.cbReceivedAfter.Text = "A&fter";
			// 
			// grpReagentType
			// 
			this.grpReagentType.AccessibleDescription = "Reagent Type";
			this.grpReagentType.AccessibleName = "Reagent Type";
			this.grpReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReagentType.Controls.Add(this.btnSelectAllReagents);
			this.grpReagentType.Controls.Add(this.btnDeselectAllReagents);
			this.grpReagentType.Controls.Add(this.lstReagentType);
			this.grpReagentType.Location = new System.Drawing.Point(60, 32);
			this.grpReagentType.Name = "grpReagentType";
			this.grpReagentType.Size = new System.Drawing.Size(168, 208);
			this.grpReagentType.TabIndex = 0;
			this.grpReagentType.TabStop = false;
			this.grpReagentType.Text = "Reagent Type*";
			// 
			// btnSelectAllReagents
			// 
			this.btnSelectAllReagents.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllReagents.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllReagents.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllReagents.Image")));
			this.btnSelectAllReagents.Location = new System.Drawing.Point(144, 0);
			this.btnSelectAllReagents.Name = "btnSelectAllReagents";
			this.btnSelectAllReagents.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllReagents.TabIndex = 2;
			this.btnSelectAllReagents.Click += new System.EventHandler(this.btnSelectAllReagents_Click);
			// 
			// btnDeselectAllReagents
			// 
			this.btnDeselectAllReagents.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllReagents.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllReagents.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllReagents.Image")));
			this.btnDeselectAllReagents.Location = new System.Drawing.Point(128, 0);
			this.btnDeselectAllReagents.Name = "btnDeselectAllReagents";
			this.btnDeselectAllReagents.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllReagents.TabIndex = 1;
			this.btnDeselectAllReagents.Click += new System.EventHandler(this.btnDeselectAllReagents_Click);
			// 
			// lstReagentType
			// 
			this.lstReagentType.AccessibleDescription = "Reagent Type";
			this.lstReagentType.AccessibleName = "Reagent Type";
			this.lstReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstReagentType.CheckOnClick = true;
			this.lstReagentType.Location = new System.Drawing.Point(8, 16);
			this.lstReagentType.Name = "lstReagentType";
			this.lstReagentType.Size = new System.Drawing.Size(152, 184);
			this.lstReagentType.TabIndex = 0;
			this.lstReagentType.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lstReagentType_ItemCheck);
			// 
			// rdoInDate
			// 
			this.rdoInDate.AccessibleDescription = "In Date Reagents";
			this.rdoInDate.AccessibleName = "In Date Reagents";
			this.rdoInDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoInDate.Checked = true;
			this.rdoInDate.Location = new System.Drawing.Point(240, 36);
			this.rdoInDate.Name = "rdoInDate";
			this.rdoInDate.Size = new System.Drawing.Size(148, 20);
			this.rdoInDate.TabIndex = 1;
			this.rdoInDate.TabStop = true;
			this.rdoInDate.Text = "&In-Date Reagents";
			this.rdoInDate.CheckedChanged += new System.EventHandler(this.rdoInDate_CheckedChanged);
			// 
			// rdoExpired
			// 
			this.rdoExpired.AccessibleDescription = "Expired Reagents";
			this.rdoExpired.AccessibleName = "Expired Reagents";
			this.rdoExpired.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoExpired.Location = new System.Drawing.Point(240, 76);
			this.rdoExpired.Name = "rdoExpired";
			this.rdoExpired.Size = new System.Drawing.Size(148, 20);
			this.rdoExpired.TabIndex = 3;
			this.rdoExpired.Text = "E&xpired Reagents";
			this.rdoExpired.CheckedChanged += new System.EventHandler(this.rdoExpired_CheckedChanged);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 208);
			this.grpImage.TabIndex = 10;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 38;
			this.picImage.TabStop = false;
			// 
			// rdoDateRange
			// 
			this.rdoDateRange.AccessibleDescription = "Expired Reagent Date Range";
			this.rdoDateRange.AccessibleName = "Expired Reagent Date Range";
			this.rdoDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoDateRange.Location = new System.Drawing.Point(240, 96);
			this.rdoDateRange.Name = "rdoDateRange";
			this.rdoDateRange.Size = new System.Drawing.Size(148, 20);
			this.rdoDateRange.TabIndex = 4;
			this.rdoDateRange.Text = "Expiration &Date Range";
			this.rdoDateRange.CheckedChanged += new System.EventHandler(this.rdoDateRange_CheckedChanged);
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "Unsatisfactory Reagents";
			this.rdoUnsatisfactory.AccessibleName = "Unsatisfactory Reagents";
			this.rdoUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(240, 56);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.Size = new System.Drawing.Size(156, 20);
			this.rdoUnsatisfactory.TabIndex = 2;
			this.rdoUnsatisfactory.Text = "&Unsatisfactory Reagents";
			this.rdoUnsatisfactory.CheckedChanged += new System.EventHandler(this.rdoUnsatisfactory_CheckedChanged);
			// 
			// FrmReagentInventory
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(410, 273);
			this.Controls.Add(this.rdoUnsatisfactory);
			this.Controls.Add(this.rdoDateRange);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.rdoExpired);
			this.Controls.Add(this.rdoInDate);
			this.Controls.Add(this.grpReagentType);
			this.Controls.Add(this.grpReceivedDate);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpExpirationDate);
			this.hlphelpChm.SetHelpKeyword(this, "View_Print_Inventory_.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(416, 300);
			this.Name = "FrmReagentInventory";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Reagent Search";
			this.Controls.SetChildIndex(this.grpExpirationDate, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpReceivedDate, 0);
			this.Controls.SetChildIndex(this.grpReagentType, 0);
			this.Controls.SetChildIndex(this.rdoInDate, 0);
			this.Controls.SetChildIndex(this.rdoExpired, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.rdoDateRange, 0);
			this.Controls.SetChildIndex(this.rdoUnsatisfactory, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpExpirationDate.ResumeLayout(false);
			this.grpReceivedDate.ResumeLayout(false);
			this.grpReagentType.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods
		private void LoadReagentTypes()
		{
			_dtReagentTypes = BOL.ReagentType.GetReagentTypes();

			foreach(DataRow drReagentType in _dtReagentTypes.Rows)
			{
				this.lstReagentType.Items.Add(drReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString());
			}
		}

		private void SetComponentProperties()
		{
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC020.DlgReagentInventorySearch());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			//set custom date and time format
			this.dtpExpireAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpExpireBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpReceivedAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpReceivedBefore.CustomFormat = Common.VBECSDateTime.DateFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpireAfter.Value = _currentDate;
			this.dtpExpireBefore.Value = _currentDate;
			this.dtpReceivedAfter.Value = _currentDate;
			this.dtpReceivedBefore.Value = _currentDate;
		}
		#endregion

		#region Events/Event Handlers
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
			char Status = char.MinValue;
			DateTime ExpirationDateAfter = DateTime.MinValue;
			DateTime ExpirationDateBefore = DateTime.MaxValue;
			DateTime ReceivedDateAfter = DateTime.MinValue;
			DateTime ReceivedDateBefore = DateTime.MaxValue;
			ArrayList ReagentTypeList = new ArrayList();

			if (this.rdoInDate.Checked == true)
			{
				Status = 'I';
			}
			else if (this.rdoExpired.Checked == true)
			{
				Status = 'O';
			}
			else if (this.rdoUnsatisfactory.Checked == true)
			{
				Status = 'U';
			}
			else if (this.rdoDateRange.Checked == true)
			{
				if (this.cbExpireAfter.Checked == true)
				{
					ExpirationDateAfter = this.dtpExpireAfter.Value;
				}
				if (this.cbExpireBefore.Checked == true)
				{
					ExpirationDateBefore = this.dtpExpireBefore.Value;
				}
			}

			if (this.cbReceivedAfter.Checked == true)
			{
				ReceivedDateAfter = this.dtpReceivedAfter.Value;
			}
			if (this.cbReceivedBefore.Checked == true)
			{
				ReceivedDateBefore = this.dtpReceivedBefore.Value;
			}

			for (int i=0 ; i<this.lstReagentType.CheckedItems.Count ; i++)
			{
				ReagentTypeList.Add(lstReagentType.CheckedItems[i]);
			}				

			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				FrmViewReagentInventory _frmV = new FrmViewReagentInventory(Status, ExpirationDateAfter, ExpirationDateBefore, ReceivedDateAfter, ReceivedDateBefore, ReagentTypeList);
				_frmV.MdiParent = this.MdiParent;
				_frmV.Show();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
			this.Close();
		}

		private void rdoDateRange_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpExpirationDate.Enabled = true;
			this.IsDirty=true;
		}

		private void rdoExpired_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpExpirationDate.Enabled = false;
			this.IsDirty=true;
		}

		private void rdoUnsatisfactory_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpExpirationDate.Enabled = false;
			this.IsDirty=true;
		}

		private void rdoInDate_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpExpirationDate.Enabled = false;
			this.IsDirty=true;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnDeselectAllReagents_Click(object sender, System.EventArgs e)
		{
			for(int index=0; index<this.lstReagentType.Items.Count; index++)
			{
				lstReagentType.SetItemCheckState(index, CheckState.Unchecked);
			}
		}

		private void btnSelectAllReagents_Click(object sender, System.EventArgs e)
		{
			for(int index=0; index<this.lstReagentType.Items.Count; index++)
			{
				lstReagentType.SetItemCheckState(index, CheckState.Checked);
			}
		}
		#endregion

		private void lstReagentType_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			this.IsDirty=true;
		}
	}
}

